/**
 * This site uses weird type of CAPTCHA. It downloads code from captcha-code.php
 * and puts it into span tag to display the code. This script extracts the code
 * with MutationObserver and skips entire download form because its only purpose
 * is to annoy the user with shitty CAPTCHA. CSS is included to hide the form.
 */

const ctaBlock = document.querySelector('#cta-block')
const captchaInput = document.querySelector('#captcha')
const downloadForm = document.querySelector('#form_download')
const submitButton = document.querySelector('#form_download button[type=submit]')

const observer = new MutationObserver((mutationList, observer) => {
  for (const mutation of mutationList) {
    if (mutation.type === 'childList') {
      const code = mutation.addedNodes[0].textContent
      console.log('Found and inserted code: ', code)
      captchaInput.value = code
      console.log('Submitting download form')
      downloadForm.requestSubmit(submitButton)
    }
  }
})
observer.observe(ctaBlock, {
  childList: true,
  subtree: true
})

console.log('observer installed: ', observer)
